% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionsQuery.R
\name{interactionsQuery}
\alias{interactionsQuery}
\title{Retrieve Interactions data for a specified gene.}
\usage{
interactionsQuery(ensgId, sourceDatabase = NULL, index = 0, size = 10)
}
\arguments{
\item{ensgId}{Character: ENSEMBL ID of the target gene (e.g., ENSG00000141510).}

\item{sourceDatabase}{Character: Source database for interactions (e.g., "intact") (default: NULL).}

\item{index}{Integer: Page index for pagination (default: 0).}

\item{size}{Integer: Number of records to retrieve (default: 10).}
}
\value{
Returns a tibble containing interactions data for the specified gene.
}
\description{
This function queries the Open Targets GraphQL API to retrieve molecular interaction data
for a specified gene.
}
\examples{
\dontrun{
result <- interactionsQuery(ensgId = "ENSG00000141510",
 sourceDatabase = "intact", size = 10)
result <- interactionsQuery(ensgId = "ENSG00000141510",
 sourceDatabase = "intact", index = 0, size = 10)
}
}
