% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneticConstraintQuery.R
\name{geneticConstraintQuery}
\alias{geneticConstraintQuery}
\title{Retrieve Genetic Constraint data for a specified gene.}
\usage{
geneticConstraintQuery(ensgId)
}
\arguments{
\item{ensgId}{Character: ENSEMBL ID of the target gene (e.g., "ENSG00000141510").}
}
\value{
Returns a tibble containing genetic constraint data for the specified gene.
}
\description{
This function queries the Open Targets Platform GraphQL API to retrieve genetic constraint data
for a specified gene, such as pLI or LOEUF scores.
}
\examples{
\dontrun{
result <- geneticConstraintQuery(ensgId = "ENSG00000141510")
}
}
