% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm_get_points_gps.R
\name{osm_get_points_gps}
\alias{osm_get_points_gps}
\title{Get GPS Points}
\usage{
osm_get_points_gps(
  bbox,
  page_number = 0,
  format = c("R", "sf", "sf_lines", "sf_points", "gpx")
)
}
\arguments{
\item{bbox}{Coordinates for the area to retrieve the notes from (\verb{left,bottom,right,top}). Floating point numbers in
degrees, expressing a valid bounding box. The maximal width (\code{right - left}) and height (\code{top - bottom}) of the
bounding box is 0.25 degree.}

\item{page_number}{Specifies which groups of 5,000 points, or page, to return. The API call does not return more
than 5,000 points at a time. In order to retrieve all of the points for a bounding box, set \code{page_number = -1}.
When this parameter is 0 (zero), the command returns the first 5,000 points; when it is 1, the command returns
points 5,001–10,000, etc. A vector is also valid (e.g. \code{0:2} to get the first 3 pages).}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"sf_lines"} (\code{"sf"} is a synonym for \code{"sf_lines"}),
\code{"sf_points"} or \code{"gpx"}.}
}
\value{
If \code{format = "R"}, returns a list of data frames with the points for each trace. For public and identifiable traces,
the data frame include the attributes \code{track_url}, \code{track_name}, and \code{track_desc}.
If \code{format = "sf_lines"}, returns a \code{sf} object from \pkg{sf}. For \code{format = "sf_points"}, returns a list of \code{sf}
object (see \code{\link[=st_as_sf]{st_as_sf()}} for details).
\subsection{\code{format = "gpx"}}{

Returns a \link[xml2:oldclass]{xml2::xml_document} with the following format:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<?xml version="1.0" encoding="UTF-8"?>
<gpx version="1.0" creator="OpenStreetMap.org" xmlns="http://www.topografix.com/GPX/1/0">
  <trk>
    <name>20190626.gpx</name>
    <desc>Footpaths near Blackweir Pond, Epping Forest</desc>
    <url>https://api.openstreetmap.org/user/John\%20Leeming/traces/3031013</url>
    <trkseg>
      <trkpt lat="51.6616100" lon="0.0534560">
        <time>2019-06-26T14:27:58Z</time>
      </trkpt>
      ...
    </trkseg>
    ...
  </trk>
  ...
</gpx>
}\if{html}{\out{</div>}}
\itemize{
\item This response is NOT wrapped in an OSM xml parent element.
\item The file format is GPX Version 1.0 which is not the current version. Verify that your tools support it.
}
}
}
\description{
Use this to retrieve the GPS track points that are inside a given bounding box (formatted in a GPX format).
}
\note{
In violation of the \href{https://www.topografix.com/GPX/1/1/#type_trksegType}{GPX standard} when downloading public
GPX traces through the API, all waypoints of non-trackable traces are randomized (or rather sorted by lat/lon) and
delivered as one trackSegment for privacy reasons. Trackable traces are delivered, sorted by descending upload
time, before the waypoints of non-trackable traces.

Private traces without \code{name}, \code{desc} and \code{url} can be separated in different items in the result if they get
split due to server pagination. Public traces are united using matching URL.
}
\examples{
pts_gps <- osm_get_points_gps(bbox = c(-0.3667545, 40.2153246, -0.3354263, 40.2364915))
## bbox as a character value also works (bbox = "-0.3667545,40.2153246,-0.3354263,40.2364915").
pts_gps

## get attributes
lapply(pts_gps, function(x) attributes(x)[c("track_url", "track_name", "track_desc")])
attr(pts_gps, "gpx_attributes")
}
\seealso{
Other get GPS' functions: 
\code{\link{osm_get_data_gpx}()},
\code{\link{osm_get_gpx_metadata}()},
\code{\link{osm_list_gpxs}()}
}
\concept{get GPS' functions}
