% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-base-eigen.r
\name{methods-eigen}
\alias{methods-eigen}
\alias{as_tbl_ord.eigen}
\alias{recover_rows.eigen}
\alias{recover_cols.eigen}
\alias{recover_inertia.eigen}
\alias{recover_coord.eigen}
\alias{recover_conference.eigen}
\alias{recover_aug_rows.eigen_ord}
\alias{recover_aug_cols.eigen_ord}
\alias{recover_aug_coord.eigen}
\alias{as_tbl_ord.eigen_ord}
\alias{recover_rows.eigen_ord}
\alias{recover_cols.eigen_ord}
\alias{recover_inertia.eigen_ord}
\alias{recover_coord.eigen_ord}
\alias{recover_conference.eigen_ord}
\alias{recover_aug_coord.eigen_ord}
\title{Functionality for eigen-decompositions}
\usage{
\method{as_tbl_ord}{eigen}(x)

\method{recover_rows}{eigen}(x)

\method{recover_cols}{eigen}(x)

\method{recover_inertia}{eigen}(x)

\method{recover_coord}{eigen}(x)

\method{recover_conference}{eigen}(x)

\method{recover_aug_rows}{eigen_ord}(x)

\method{recover_aug_cols}{eigen_ord}(x)

\method{recover_aug_coord}{eigen}(x)

\method{as_tbl_ord}{eigen_ord}(x)

\method{recover_rows}{eigen_ord}(x)

\method{recover_cols}{eigen_ord}(x)

\method{recover_inertia}{eigen_ord}(x)

\method{recover_coord}{eigen_ord}(x)

\method{recover_conference}{eigen_ord}(x)

\method{recover_aug_rows}{eigen_ord}(x)

\method{recover_aug_cols}{eigen_ord}(x)

\method{recover_aug_coord}{eigen_ord}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"eigen"} returned by \code{\link[base:eigen]{base::eigen()}} when the parameter
\code{only.values} is set to \code{FALSE} or of class \code{"eigen_ord"} returned by
\code{\link[=eigen_ord]{eigen_ord()}}.
}
\details{
\code{\link[base:eigen]{base::eigen()}} usually returns an object of class \code{"eigen"}, which contains
the numerical eigendecomposition without annotations such as row and column
names. To facilitate downstream analysis, \code{\link[=eigen_ord]{eigen_ord()}} returns a modified
'eigen' object with row names taken (if available) from the original data and
column names indicating the integer index of each eigenvector.
}
\examples{
# eigendecompose covariance matrix of ability tests
gi_eigen <- eigen(ability.cov$cov)

# recover eigenvectors
get_rows(gi_eigen)
identical(get_cols(gi_eigen), get_rows(gi_eigen))

# wrap as a 'tbl_ord'
as_tbl_ord(gi_eigen)

# same eigendecomposition, preserving names
gi_eigen <- eigen_ord(ability.cov$cov)

# wrap as a 'tbl_ord' and augment with dimension names
augment_ord(as_tbl_ord(gi_eigen))

# decomposition returns pure eigenvectors
get_conference(gi_eigen)
}
\seealso{
Other methods for eigen-decomposition-based techniques: 
\code{\link{methods-cmds}},
\code{\link{methods-factanal}},
\code{\link{methods-princomp}}

Other models from the base package: 
\code{\link{methods-svd}}
}
\concept{methods for eigen-decomposition-based techniques}
\concept{models from the base package}
