#' Miscellaneous tests for log-linear models.
#' Comparisons found at:
#' https://online.stat.psu.edu/stat504/lesson/11/11.3 and pages that it links to.
#'

test_that("Independence model output matches", {
  r <- nrow(movies)
  expect_equal(r, ncol(movies))
  x <- log_linear_main_effect_design(movies)
  independence <- log_linear_fit(movies, x)
  expect_true(abs(43.2325 - independence$g_squared) <= 0.00005)
  expect_equal(4, independence$df)
}
)


test_that("Symmetric model output matches", {
  r <- nrow(movies)
  expect_equal(r, ncol(movies))
  x <- matrix(0.0, r * r, 6)
  index <- 1
  for (i in 1:r) {
    for (j in 1:r) {
       if (i==1 && j == 1) x[index, 1] <- 1
       if (i==2 && j == 2) x[index, 2] <- 1
       if (i==3 && j == 3) x[index, 3] <- 1
       if ((i==1 && j == 2) || (i == 2 && j == 1)) x[index, 4] <- 1
       if ((i==1 && j == 3) || (i == 3 && j == 1)) x[index, 5] <- 1
       if ((i==2 && j == 3) || (i == 3 && j == 2)) x[index, 6] <- 1
       index <- index + 1
    }
  }
  symmetry <- log_linear_fit(movies, x)
  expect_true(abs(0.59276 - symmetry$g_squared) <= 0.00005)
  expect_equal(3, symmetry$df)
  beta <- symmetry$beta
  expect_true(abs(3.1781 - beta[1]) <= 0.00005)
  expect_true(abs(2.5649 - beta[2]) <= 0.00005)
  expect_true(abs(4.1589 - beta[3]) <= 0.00005)
  expect_true(abs(2.0794 - beta[4]) <= 0.00005)
  expect_true(abs(2.4423 - beta[5]) <= 0.00005)
  expect_true(abs(2.3026 - beta[6]) <= 0.00005)
}
)


test_that("quasi-symmetry matches", {
  r <- nrow(movies)
  x <- log_linear_main_effect_design(movies)
  m <- movies
  dim(m) <- NULL
  x1 <- as.factor(rep(1:3, each=3))
  x2 <- as.factor(rep(1:3, times=3))
  x <- model.matrix(m ~ x1 + x2)

  i12 <- rep(0.0, nrow(x))
  i13 <- rep(0.0, nrow(x))
  i23 <- rep(0.0, nrow(x))
  index <- 1
  for (i in 1:r) {
    for (j in 1:r) {
      if ((i==1 && j == 2) || (i == 2 && j == 1)) i12[index] <- 1
      if ((i==1 && j == 3) || (i == 3 && j == 1)) i13[index] <- 1
      if ((i==2 && j == 3) || (i == 3 && j == 2)) i23[index] <- 1
      index <- index + 1
    }
  }

  x <- log_linear_append_column(x, i12)
  x <- log_linear_append_column(x, i13)
  x <- log_linear_append_column(x, i23)

  quasi_symmetry <- log_linear_fit(movies, x)
  expect_true(abs(6.0515e-03 - quasi_symmetry$g_squared) <= 5.0e-8,
              info=paste(6.0515e-3, quasi_symmetry$g_squared))
  expect_equal(1, quasi_symmetry$df)
  beta <- quasi_symmetry$beta
  expect_true(abs(3.1781 - beta[1]) < 0.00005)
  expect_true(abs(-0.3188 - beta[2]) < 0.00005)
  expect_true(abs(0.3679 - beta[3]) < 0.00005)
  expect_true(abs(-0.2943 - beta[4]) < 0.00005)
  expect_true(abs(0.6129 - beta[5]) < 0.00005)
  expect_true(abs(-0.7921 - beta[6]) < 0.00005)
  expect_true(abs(-1.2336 - beta[7]) < 0.00005)
  expect_true(abs(-1.0654 - beta[8]) < 0.00005)
}
)


test_that("political data from Agresti Appendix D4 run", {
  n <- c(100, 156, 143,
         141, 210, 119,
         127,  72,  15)

  x <- matrix(c(1,  1,  0,  1,  0, -1,  0,
                1,  1,  0,  0,  1,  0,  0,
                1,  1,  0, -1, -1,  1,  0,
                1,  0,  1,  1,  0,  0, -1,
                1,  0,  1,  0,  1,  0,  0,
                1,  0,  1, -1, -1,  0,  1,
                1, -1, -1,  1,  0,  1,  1,
                1, -1, -1,  0,  1,  0,  0,
                1, -1, -1, -1, -1, -1, -1), nrow=9, byrow = TRUE)

  political <- matrix(n, nrow=3, byrow=TRUE)
  expectedRowSums <- c(399, 470, 214)
  expect_equal(expectedRowSums, rowSums(political))

  expected_g_squared <- 2.814931
  expected_beta <- c(4.6202664,
                     0.2414043,
                     0.4134641,
                     0.1724260,
                     0.2666393,
                     0.4947016,
                     0.2239581)

  expected_m_hat <- matrix(c(93.63414, 168.73171, 136.63414,
                      145.79454, 200.41091, 123.79454,
                      128.57131, 68.85738, 16.57131), nrow=3, byrow=TRUE)

  result <- log_linear_fit(political, x)

  expect_true(abs(expected_g_squared - result$g_squared) <= 0.000005)
  for (i in 1:7) {
    expect_true(abs(expected_beta[i] - result$beta[i]) <= 0.000005)
  }

  for (i in 1:3) {
    for (j in 1:3) {
      expect_true(abs(expected_m_hat[i, j] - result$expected[i, j]) <= 0.000005)
    }
  }
}
)
