% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-DownloadModels.R
\name{initiate_model_download}
\alias{initiate_model_download}
\alias{initiate_run_download}
\alias{initiate_workset_download}
\alias{delete_download_files}
\alias{delete_download_files_async}
\alias{get_download_log}
\alias{get_download_logs_model}
\alias{get_download_logs_all}
\alias{get_download_filetree}
\title{Download Model, Model Run Results, or Input Parameters}
\usage{
initiate_model_download(model)

initiate_run_download(model, run)

initiate_workset_download(model, set)

delete_download_files(folder)

delete_download_files_async(folder)

get_download_log(name)

get_download_logs_model(model)

get_download_logs_all()

get_download_filetree(folder)
}
\arguments{
\item{model}{Model digest or model name.}

\item{run}{Model run digest, run stamp or run name, modeling task run
stamp or task run name.}

\item{set}{Name of workset (input set of model parameters).}

\item{folder}{Download folder file name.}

\item{name}{Output table name.}
}
\value{
Nothing, invisibly.
}
\description{
Functions to download model, model run results, or input parameters. More
information about these API endpoints can be found at
\href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#download-model-model-run-results-or-input-parameters}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_download_logs_model('RiskPaths')
}


}
