% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-ReadParameters.R
\name{get_workset_param}
\alias{get_workset_param}
\alias{get_workset_param_csv}
\alias{get_run_param}
\alias{get_run_param_csv}
\title{Read Parameters}
\usage{
get_workset_param(model, set, name)

get_workset_param_csv(model, set, name)

get_run_param(model, run, name)

get_run_param_csv(model, run, name)
}
\arguments{
\item{model}{Model digest or model name.}

\item{set}{Name of workset (input set of model parameters).}

\item{name}{Output table name.}

\item{run}{Model run digest, run stamp or run name, modeling task run
stamp or task run name.}
}
\value{
A \code{list} or \code{tibble}.
}
\description{
Functions for retrieving parameters from worksets or model runs. More
information about these API endpoints can be found at
\href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#read-parameters-output-tables-or-microdata-values}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_workset_param("RiskPaths", "Default", "AgeBaselinePreg1")
}

}
