% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-Services.R
\name{get_service_config}
\alias{get_service_config}
\alias{get_service_state}
\alias{get_disk_use}
\alias{refresh_disk_use}
\alias{get_active_job_state}
\alias{get_queue_job_state}
\alias{get_hist_job_state}
\alias{set_queue_job_pos}
\alias{delete_job_hist}
\title{OpenM++ Model Run Jobs and Service State}
\usage{
get_service_config()

get_service_state()

get_disk_use()

refresh_disk_use()

get_active_job_state(job)

get_queue_job_state(job)

get_hist_job_state(job)

set_queue_job_pos(pos, job)

delete_job_hist(job)
}
\arguments{
\item{job}{Model run submission time stamp.}

\item{pos}{Position.}
}
\value{
A \code{list} from a JSON response object, or nothing (invisibly).
}
\description{
Functions for retrieving or deleting service information. More information about these API endpoints can be found at \href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#model-run-jobs-and-service-state}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_service_config()
get_service_state()
get_disk_use()
}

}
