% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{login}
\alias{login}
\title{Log in on a specific back-end}
\usage{
login(user = NULL, password = NULL, provider = NULL, config = NULL, con = NULL)
}
\arguments{
\item{user}{the user name}

\item{password}{the password}

\item{provider}{provider object as obtained by 'list_oidc_providers()' or the name of the provider in the provider list. If NULL
and \code{provider_type="oidc"} then the first available provider is chosen from the list.}

\item{config}{named list containing 'client_id' and 'secret' or a path to the configuration file (type JSON). If NULL and
\code{provider_type="oidc"} the configuration parameters are taken from the default authentication client of the OIDC provider.}

\item{con}{connected back-end connection (optional) otherwise \code{\link[=active_connection]{active_connection()}}
is used.}
}
\value{
a connected and authenticated back-end connection
}
\description{
Retrieves the bearer-token from the back-end by sending user name and password to the back-end. This step
is usually performed during the 'connect' step. If you are only connected to a back-end in order to
explore the capabilities and want to compute something, then you need to log in afterwards.
}
\details{
Based on the general login type (\link{BasicAuth} or \link{OIDCAuth}) there need to be different configurations. The basic
authentication (if supported) is the simplest login mechanism for which user need to enter their credentials directly as
\code{user} and \code{password}.

For the Open ID connect authentication the user needs to select one of the accepted OIDC providers of
\code{\link[=list_oidc_providers]{list_oidc_providers()}} as \code{provider}. Alternatively the name of the provider suffices.
For further configuration, you can pass a named list of values as \code{config} or
a file path to a JSON file.

There are many different authentication mechanisms for OIDC and OAuth2.0, which OIDC is based on. The 'openeo' package supports
currently the authorization_code, authorization_code+pkce, device_code and device_code+pkce (see \link{OIDCAuth}). For authorization_code
you need to state the \code{client_id} and \code{secret} in the configuration options. In general the most comfortable available login mechanism is chosen
automatically (1. device_code+pkce, 2. device_code 3. authorization_code+pkce, 4. authorization_code). For example, with the device_code
flow you normally don't even need to specify any additional configuration.

If you really want to choose the authorization flow mechanism manually, you can add \code{grant_type} in the configuration
list. You can then use the following values:

\itemize{
\item authorization_code
\item authorization_code+pkce
\item urn:ietf:params:oauth:grant-type:device_code
\item urn:ietf:params:oauth:grant-type:device_code+pkce
}
}
\section{Configuration options}{

\describe{
\item{\code{client_id}}{The client id to use, when authorization code is selected as grant_type}
\item{\code{secret}}{The client secret that matches the client_id to identify and validate this local client towards the identity provider}
\item{\code{grant_type}}{Manually selected authentication method from the ones stated above.}
\item{\code{scope}}{Manually select the scopes for the authentication method. Note: this is usually filled automatically with the information
from the provider object}
}
}

\examples{
\dontrun{
# simple connection without login to maybe explore the capabilities of a back-end first
# the URL won't work and is just to demonstrate how to write the code
con = connect(host='http://example.openeo.org',version='1.0.0')

# some back-ends support logging in throug OIDC without any parameters
login()

# basic authentication, credentials are dummy values
login(user='user',password='password')

# or alternatively the OIDC login
login(provider=provider, config=config)

# with device_code+pkce enabled at the OIDC provider you can even use this
login(provider="your_named_provider")

}
}
