% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_data.R
\name{get_sample}
\alias{get_sample}
\title{Get sample data}
\usage{
get_sample(
  graph,
  replace_aoi = TRUE,
  spatial_extent = NULL,
  execution = "sync",
  immediate = TRUE,
  con = NULL,
  ...
)
}
\arguments{
\item{graph}{a ProcessGraph, a Process or the final node in a process for which the sample shall be calculated}

\item{replace_aoi}{a logical flag to indicate whether or not the original spatial extent shall be substituted with a different one, default TRUE}

\item{spatial_extent}{a bounding box or a spatial feature from which to derive a bounding box}

\item{execution}{\code{sync} or \code{async} which indicates the processing chain, a not "async" value results in a synchronous processing}

\item{immediate}{flag to be considered if the retrieval shall be immediately queued on the back-end}

\item{con}{connected and authenticated openEO client (optional) otherwise \code{\link[=active_connection]{active_connection()}}
is used.}

\item{...}{additional parameters that are passed to \code{\link[=compute_result]{compute_result()}} or \code{\link[=create_job]{create_job()}}}
}
\description{
In order to inspect data locally a very small spatial extent will be processed, downloaded and made available in R.
}
\details{
In order to get a better understanding about the processing mechanisms and the data structures used in the openEO back-end,
it helps to check the actual data from time to time. This function aids the user in doing to. It replaces all spatial
extents of the derived process graph with a new spatial extent which is calculated by the first spatial extent of the
mandatory openEO process 'load_collection'. We take the center of the extent and add 0.0003 degrees to it. In case the
coordinate reference system is not in WGS84, then the bounding box will be transformed into geodetic WGS84 beforehand, if
the package 'sf' is present.

If the spatial extent was explicitly set to a small custom extent, then you can disable the replacement of the area of
interest with \code{replace_aoi = FALSE}.
}
