% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importEurope.R
\name{importEurope}
\alias{importEurope}
\title{Import air quality data from European database until February 2024}
\usage{
importEurope(
  site = "debw118",
  year = 2018,
  tz = "UTC",
  meta = FALSE,
  to_narrow = FALSE,
  progress = TRUE
)
}
\arguments{
\item{site}{The code of the site(s).}

\item{year}{Year or years to import. To import a sequence of years from 1990
to 2000 use \code{year = 1990:2000}. To import several specific years use \code{year = c(1990, 1995, 2000)} for example.}

\item{tz}{Not used}

\item{meta}{Should meta data be returned? If \code{TRUE} the site type, latitude
and longitude are returned.}

\item{to_narrow}{By default the returned data has a column for each
pollutant/variable. When \code{to_narrow = TRUE} the data are stacked into a
narrow format with a column identifying the pollutant name.}

\item{progress}{Show a progress bar when many sites/years are being imported?
Defaults to \code{TRUE}.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
This function is a simplified version of the \code{saqgetr} package (see
\url{https://github.com/skgrange/saqgetr}) for accessing European air quality
data. As \code{saqgetr} was retired in February 2024, this function has also been
retired, but can still access European air quality data up until that
retirement date. Consider using the EEA Air Quality Download Service instead
(\url{https://eeadmz1-downloads-webapp.azurewebsites.net/}).
}
\examples{

# import data for Stuttgart Am Neckartor (S)
\dontrun{
stuttgart <- importEurope("debw118", year = 2010:2019, meta = TRUE)
}

}
\seealso{
Other import functions: 
\code{\link{importADMS}()},
\code{\link{importAURN}()},
\code{\link{importImperial}()},
\code{\link{importMeta}()},
\code{\link{importTraj}()},
\code{\link{importUKAQ}()}
}
\concept{import functions}
