% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_comment}
\alias{body_comment}
\title{Add comment in a 'Word' document}
\usage{
body_comment(x, cmt = ftext(""), author = "", date = "", initials = "")
}
\arguments{
\item{x}{an rdocx object}

\item{cmt}{a set of blocks to be used as comment content returned by
function \code{\link[=block_list]{block_list()}}.}

\item{author}{comment author.}

\item{date}{comment date}

\item{initials}{comment initials}
}
\description{
Add a comment at the cursor location. The comment
is added on the first run of text in the current paragraph.
}
\examples{
doc <- read_docx()
doc <- body_add_par(doc, "Paragraph")
doc <- body_comment(doc, block_list("This is a comment."))
docx_file <- print(doc, target = tempfile(fileext = ".docx"))
docx_comments(read_docx(docx_file))
}
