% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{block_gg}
\alias{block_gg}
\title{'ggplot' block}
\usage{
block_gg(
  value,
  fp_p = fp_par(),
  width = 6,
  height = 5,
  res = 300,
  scale = 1,
  unit = "in"
)
}
\arguments{
\item{value}{'ggplot' object}

\item{fp_p}{paragraph formatting properties, see \code{\link[=fp_par]{fp_par()}}}

\item{width, height}{image size in units expressed by the unit argument.
Defaults to "in"ches.}

\item{res}{resolution of the png image in ppi}

\item{scale}{Multiplicative scaling factor, same as in ggsave}

\item{unit}{One of the following units in which the width and height
arguments are expressed: "in", "cm" or "mm".}
}
\description{
A simple wrapper to add a 'ggplot' object as a png in a document.
It produces an object of class 'block_gg' with a corresponding method \code{\link[=to_wml]{to_wml()}}
that can be used to convert the object to a WordML string.
}
\examples{
library(officer)
if (require("ggplot2")) {
  set.seed(2)
  doc <- read_docx()

  z <- body_append_start_context(doc)

  for (i in seq_len(3)) {
    df <- data.frame(x = runif(10), y = runif(10))
    gg <- ggplot(df, aes(x = x, y = y)) + geom_point()

    write_elements_to_context(
      context = z,
      block_gg(
        value = gg
      )
    )
  }

  doc <- body_append_stop_context(z)

  print(doc, target = tempfile(fileext = ".docx"))
}
}
\seealso{
Other block functions for reporting: 
\code{\link{block_caption}()},
\code{\link{block_list}()},
\code{\link{block_pour_docx}()},
\code{\link{block_section}()},
\code{\link{block_table}()},
\code{\link{block_toc}()},
\code{\link{fpar}()},
\code{\link{plot_instr}()},
\code{\link{unordered_list}()}
}
\concept{block functions for reporting}
