% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_diagonal_indices.R
\name{matrix_diagonal_indices}
\alias{matrix_diagonal_indices}
\title{Get indices of matrix diagonal}
\usage{
matrix_diagonal_indices(n, triangular = NULL)
}
\arguments{
\item{n}{[\code{integer(1)}]\cr
The matrix dimension.}

\item{triangular}{[\code{NULL} or \code{character(1)}]\cr
If \code{NULL} (default), all elements of the matrix are considered. If
\code{"lower"} (\code{"upper"}), only the lower- (upper-) triangular matrix
is considered.}
}
\value{
An \code{integer} \code{vector}.
}
\description{
This function returns the indices of the diagonal elements of a quadratic
matrix.
}
\examples{
# indices of diagonal elements
n <- 3
matrix(1:n^2, n, n)
matrix_diagonal_indices(n)

# indices of diagonal elements of lower-triangular matrix
L <- matrix(0, n, n)
L[lower.tri(L, diag=TRUE)] <- 1:((n * (n + 1)) / 2)
L
matrix_diagonal_indices(n, triangular = "lower")

# indices of diagonal elements of upper-triangular matrix
U <- matrix(0, n, n)
U[upper.tri(U, diag=TRUE)] <- 1:((n * (n + 1)) / 2)
U
matrix_diagonal_indices(n, triangular = "upper")
}
\seealso{
Other matrix helpers: 
\code{\link{check_correlation_matrix}()},
\code{\link{check_covariance_matrix}()},
\code{\link{check_transition_probability_matrix}()},
\code{\link{cov_to_chol}()},
\code{\link{diff_cov}()},
\code{\link{insert_matrix_column}()},
\code{\link{matrix_indices}()},
\code{\link{sample_correlation_matrix}()},
\code{\link{sample_covariance_matrix}()},
\code{\link{sample_transition_probability_matrix}()},
\code{\link{stationary_distribution}()}
}
\concept{matrix helpers}
\keyword{indexing}
