% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.power.R
\name{plot.power}
\alias{plot.power}
\title{Plot statistical power curves under a fixed budget across optimal design
parameters}
\usage{
\method{plot}{power}(
  expr,
  nlim = c(2, 300),
  plim = c(0.01, 0.99),
  powerlim = c(0, 1),
  plot.title = NULL,
  m = NULL,
  by = c("n", "p"),
  legend = TRUE,
  nlab = "Level-One Sample Size (n)",
  plab = "Proportion (p)",
  Jlab = "Level-Two Sample Size (J)",
  powerlab = "Statistical Power"
)
}
\arguments{
\item{expr}{Returned objects from an od function (e.g., od.2m, od.2m.mod).}

\item{nlim}{The plot range for n, default value is c(2, 50).}

\item{plim}{The plot range for p, default value is c(0, 1).}

\item{powerlim}{The limit for plotting power curves.}

\item{plot.title}{The title of the plot (e.g., plot.title = "Power Curves").
The default is NULL.}

\item{m}{Total budget, default is the total costs of sampling 60
sites.}

\item{by}{Dimensions to plot power curves by the optimal design parameters.
The default value is by all optimal design parameters for a type of design.
For example, default values are by = "p" for single-level designs,
by = c("n", "p") for two-level designs,
and by = c("n", "p", "J") for three-level designs.}

\item{legend}{Logical; present plot legend if TRUE. The default is TRUE.}

\item{nlab}{Label for the x-axis when the plot is by the optimal design
parameter "n".}

\item{plab}{Label for the x-axis when the plot is by the optimal design
parameter "p".}

\item{Jlab}{Label for the x-axis when the plot is by the optimal design
parameter "J".}

\item{powerlab}{The label for the statistical power.}
}
\description{
This function plots statistical power curves (for main,
    moderation, and/or mediation effects) under a fixed budget
    across optimal design parameters.
}
