% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection-pane.R
\name{odbcListObjectTypes}
\alias{odbcListObjectTypes}
\title{Return the object hierarchy supported by a connection.}
\usage{
odbcListObjectTypes(connection)
}
\arguments{
\item{connection}{A connection object, as returned by \code{dbConnect()}.}
}
\value{
The hierarchy of object types supported by the connection.
}
\description{
Lists the object types and metadata known by the connection, and how those
object types relate to each other.
}
\details{
The returned hierarchy takes the form of a nested list, in which each object
type supported by the connection is a named list with the following
attributes:

\describe{
\item{contains}{A list of other object types contained by the object, or
"data" if the object contains data}
\item{icon}{An optional path to an icon representing the type}
}
For instance, a connection in which the top-level object is a schema that
contains tables and views, the function will return a list like the
following:

\preformatted{list(schema = list(contains = list(
                   list(name = "table", contains = "data")
                   list(name = "view", contains = "data"))))

}
}
