% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDictionaryEntries.R
\name{getDictionaryEntries}
\alias{getDictionaryEntries}
\title{Lookup entries in a dictionary}
\usage{
getDictionaryEntries(labbcat.url, manager.id, dictionary.id, keys)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{manager.id}{The layer manager ID of the dictionary, as returned by getDictionaries}

\item{dictionary.id}{The ID of the dictionary, as returned by getDictionaries}

\item{keys}{A list of keys (words) identifying entries to look up}
}
\value{
A data frame with the keys and their dictionary entries, if any.
}
\description{
Lookup entries in a dictionary
}
\examples{
\dontrun{
keys <- c("the", "quick", "brown", "fox")

## get the pronunciations according to CELEX
entries <- getDictionaryEntries(labbcat.url, "CELEX-EN", "Phonology (wordform)", keys)
}

}
\seealso{
Other dictionary functions: 
\code{\link{addDictionaryEntry}()},
\code{\link{addLayerDictionaryEntry}()},
\code{\link{deleteLexicon}()},
\code{\link{getDictionaries}()},
\code{\link{loadLexicon}()},
\code{\link{removeDictionaryEntry}()},
\code{\link{removeLayerDictionaryEntry}()}
}
\concept{dictionary functions}
\keyword{dictionary}
