% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.nonprob}
\alias{coef.nonprob}
\title{Returns Coefficients of the Underlying Models}
\usage{
\method{coef}{nonprob}(object, ...)
}
\arguments{
\item{object}{a \code{nonprob} class object}

\item{...}{other arguments passed to methods (currently not supported)}
}
\value{
a \code{list} with two entries:
\itemize{
\item{\code{"coef_sel"} a matrix of coefficients for the selection equation if possible, else NULL}
\item{\code{"coef_dr"} a matrix of coefficients for the outcome equation(s) if possible, else NULL}
}
}
\description{
Returns a \code{list} of coefficients for the selection and the outcome models
}
\examples{

data(admin)
data(jvs)

jvs_svy <- svydesign(ids = ~ 1,  weights = ~ weight,
strata = ~ size + nace + region, data = jvs)

ipw_est1 <- nonprob(selection = ~ region + private + nace + size,
target = ~ single_shift,
svydesign = jvs_svy,
data = admin, method_selection = "logit", se = FALSE
)

coef(ipw_est1)

}
