% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dExponentialLogisticGrowth.R
\name{dExponentialLogisticGrowth}
\alias{dExponentialLogisticGrowth}
\alias{rExponentialLogisticGrowth}
\title{Exponential-Logistic Growth Model}
\usage{
dExponentialLogisticGrowth(x, a, b, k, r1, r2, mu, log)

rExponentialLogisticGrowth(n, a, b, k, r1, r2, mu)
}
\arguments{
\item{x}{vector of calendar years (in BP).}

\item{a}{lower (earliest) limit of the distribution (in BP).}

\item{b}{upper (latest) limit of the distribution (in BP).}

\item{k}{initial proportion of the carrying capacity (must be between 0 and 1).}

\item{r1}{growth rate of the exponential phase.}

\item{r2}{growth rate of logistic phase.}

\item{mu}{change point (in BP).}

\item{log}{TRUE or 1 to return log probability. FALSE or 0 to return probability.}

\item{n}{number of random draws. Currently only n = 1 is supported, but the argument exists for standardization of "r" functions.}
}
\value{
For \code{dExponentialLogisticGrowth}: the probability (or likelihood) or log probability of an observed date x (in Cal BP). For \code{rExponentialLogisticGrowth} a simulated date in Cal BP.
}
\description{
Density and random generation of a exponential-logistic growth model distribution.
}
\examples{
p = list(r1=-0.001,r2=0.01,mu=5200,k=0.2)
modelPlot(model = dExponentialLogisticGrowth,a=6000,b=4000,params=p,alpha = 1)
}
\author{
Enrico Crema
}
