% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESPNTeam.R
\name{get_espn_teams}
\alias{get_espn_teams}
\title{Get ESPN teams by season}
\usage{
get_espn_teams(season = get_season_now()$seasonId\%\%10000)
}
\arguments{
\item{season}{integer Season in YYYY}
}
\value{
tibble with one row per team
}
\description{
\code{get_espn_teams()} retrieves ESPN hyperlinks for each team for a given \code{season}; the hyperlinks are formatted in \verb{base/seasons/\{ESPN Season ID\}/coaches/\{ESPN Team ID\}?query}. Access \code{get_seasons()} for \code{season} reference. May soon be reworked to only return the ESPN Team IDs.
}
\examples{
ESPN_teams_20242025 <- get_espn_teams(2025)
}
