% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_rosters_weekly.R
\name{load_rosters_weekly}
\alias{load_rosters_weekly}
\title{Load Weekly Rosters}
\usage{
load_rosters_weekly(
  seasons = most_recent_season(roster = TRUE),
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector of seasons to return, defaults to returning
this year's data if it is March or later. If set to \code{TRUE}, will return all available data.
Data available back to 2002.}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
A tibble of weekly roster data.
}
\description{
Returns week level rosters (rather than latest for a given season as returned by \code{load_rosters()})
}
\examples{
\dontshow{.for_cran()}
\donttest{
try({ # prevents cran errors
  load_rosters_weekly(2020)
})
}

}
\seealso{
Issues with this data should be filed here: \url{https://github.com/nflverse/nflverse-data}
}
