% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orient_rpi.R
\name{orient_rpi}
\alias{orient_rpi}
\alias{orient_rpi_file}
\alias{is_rpi_oriented}
\title{Reorient an Image to RPI orientation}
\usage{
orient_rpi(file, verbose = TRUE)

orient_rpi_file(file, verbose = TRUE)

is_rpi_oriented(file, verbose = FALSE)
}
\arguments{
\item{file}{Object of class \code{nifti} or character path}

\item{verbose}{print diagnostic messages}
}
\value{
List of 3 elements
\itemize{
\item \code{img}: Reoriented image of class \code{nifti}
\item \code{convention}: Convention (Neurological/Radiological) of original image
\item \code{orientation}: Original image orientations
}
}
\description{
Reorient an Image to RPI orientation
}
\note{
`orient_rpi` and `orient_rpi_file` uses `RNifti` to ensure the 
reading orientation
}
\examples{
lr_fname = system.file( "nifti", "mniLR.nii.gz", package = "oro.nifti")
img = readnii(lr_fname)

rl_fname = system.file( "nifti", "mniRL.nii.gz", package = "oro.nifti")
rl_img = readnii(rl_fname)
stopifnot(all(rl_img[nrow(rl_img):1,,] == img))

reor = orient_rpi(rl_fname)
stopifnot(all(img == reor$img))

rev = reverse_orient_rpi(reor$img, convention = reor$convention,
orientation = reor$orientation)
stopifnot(all(rev == rl_img))
}
