#' Get an individual submission answer
#'
#' @template submission_id
#' @return list of all answers
#' @export
#' @examples
#' \dontshow{
#' vcr::insert_example_cassette("ns_get_submission", package = "nettskjemar")
#' nettskjemar:::mock_if_no_auth()
#' }
#' ns_get_submission(27685292)
#' \dontshow{
#' vcr::eject_cassette()
#' }
ns_get_submission <- function(submission_id) {
  ns_req() |>
    httr2::req_url_path_append(
      "form",
      "submission",
      submission_id
    ) |>
    httr2::req_perform() |>
    httr2::resp_body_json()
}

#' Get an individual submission answer as a pdf
#'
#' Writes the Nettskjema generated report PDF to
#' the specified path, defaults to `<submission_id>.pdf`
#'
#' @template submission_id
#' @template path
#' @return nothing, writes file to path
#' @noRd
#' @examples
#' \dontrun{
#' ns_get_submission_pdf(27685292)
#' ns_get_submission_pdf(27685292, "~/Desktop/1100.pdf")
#' }
ns_get_submission_pdf <- function(
  submission_id,
  path = sprintf("%s.pdf", submission_id)
) {
  ns_req() |>
    httr2::req_url_path_append(
      "form",
      "submission",
      submission_id,
      "pdf"
    ) |>
    httr2::req_headers(Accept = "application/pdf") |>
    httr2::req_perform() |>
    httr2::resp_body_raw() |>
    writeBin(path)
}
