% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackFromStore.R
\name{stackFromStore}
\alias{stackFromStore}
\title{Select files from a stored set of NEON data, created by neonstore package methods or another method}
\usage{
stackFromStore(
  filepaths,
  dpID,
  site = "all",
  startdate = NA,
  enddate = NA,
  pubdate = NA,
  timeIndex = "all",
  level = "dp04",
  var = NA,
  zipped = FALSE,
  package = "basic",
  load = TRUE,
  nCores = 1
)
}
\arguments{
\item{filepaths}{Either a vector of filepaths pointing to files to be stacked, or a single directory containing files that can be stacked, with selection criteria detmined by the other inputs. In both cases files to be stacked must be either site-month zip files or unzipped folders corresponding to site-month zips. [character]}

\item{dpID}{The NEON data product ID of the data to be stacked [character]}

\item{site}{Either "all" or a vector of NEON site codes to be stacked [character]}

\item{startdate}{Either NA, meaning all available dates, or a character vector in the form YYYY-MM, e.g. 2017-01. Defaults to NA. [character]}

\item{enddate}{Either NA, meaning all available dates, or a character vector in the form YYYY-MM, e.g. 2017-01. Defaults to NA. [character]}

\item{pubdate}{The maximum publication date of data to include in stacking, in the form YYYY-MM-DD. If NA, the most recently published data for each product-site-month combination will be selected. Otherwise, the most recent publication date that is older than pubdate will be selected. Thus the data stacked will be the data that would have been accessed on the NEON Data Portal, if it had been downloaded on pubdate. [character]}

\item{timeIndex}{Either the string 'all', or the time index of data to be stacked, in minutes. Only applicable to sensor (IS) and eddy covariance data. Defaults to 'all'. [character]}

\item{level}{Data product level of data to stack. Only applicable to eddy covariance (SAE) data; see stackEddy() documentation. [character]}

\item{var}{Variables to be extracted and stacked from H5 files. Only applicable to eddy covariance (SAE) data; see stackEddy() documentation. [character]}

\item{zipped}{Should stacking use data from zipped files or unzipped folders? This option allows zips and their equivalent unzipped folders to be stored in the same directory; stacking will extract whichever is specified. Defaults to FALSE, i.e. stacking using unzipped folders. [logical]}

\item{package}{Either "basic" or "expanded", indicating which data package to stack. Defaults to basic. [character]}

\item{load}{If TRUE, stacked data are read into the current R environment. If FALSE, stacked data are written to the directory where data files are stored. Defaults to TRUE. [logical]}

\item{nCores}{Number of cores to use for optional parallel processing. Defaults to 1. [integer]}
}
\value{
If load=TRUE, returns a named list of stacked data tables. If load=FALSE, return is empty and stacked files are written to data directory.
}
\description{
Select files from a stored set based on input criteria and pass to stackByTable() or stackEddy()
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
}
