% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmsnburr_distribution.R
\name{gmsnburr}
\alias{gmsnburr}
\alias{dgmsnburr}
\alias{pgmsnburr}
\alias{qgmsnburr}
\alias{rgmsnburr}
\title{GMSNBurr distribution}
\usage{
dgmsnburr(x, mu = 0, sigma = 1, alpha = 1, beta = 1, log = FALSE)

pgmsnburr(
  q,
  mu = 0,
  sigma = 1,
  alpha = 1,
  beta = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

qgmsnburr(
  p,
  mu = 0,
  sigma = 1,
  alpha = 1,
  beta = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

rgmsnburr(n, mu = 0, sigma = 1, alpha = 1, beta = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{a  location parameter.}

\item{sigma}{a scale parameter.}

\item{alpha}{a shape parameter.}

\item{beta}{a shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p)
The default value of this parameter is FALSE.}

\item{lower.tail}{logical;if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vectors of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dgmsnburr} gives the density , \code{pgmasnburr} gives the distribution function,
\code{qgmsnburr} gives quantiles function, \code{rgmsnburr} generates random numbers.
}
\description{
To calculate density function, distribution function, quantile function, and  build data from random generator function 
for the GMSNBurr Distribution.
}
\details{
GMSNBurr Distribution 

The GMSNBurr distribution with parameters \eqn{\mu}, \eqn{\sigma},\eqn{\alpha}, and \eqn{\beta}
has density:
\deqn{f(x |\mu,\sigma,\alpha,\beta) =  {\frac{\omega}{{B(\alpha,\beta)}\sigma}}{{\left(\frac{\beta}{\alpha}\right)}^\beta} {{\exp{\left(-\beta \omega {\left(\frac{x-\mu}{\sigma}\right)}\right)} {{\left(1+{\frac{\beta}{\alpha}} {\exp{\left(-\omega {\left(\frac{x-\mu}{\sigma}\right)}\right)}}\right)}^{-(\alpha+\beta)}}}}}
where \eqn{-\infty<x<\infty,  -\infty<\mu<\infty,  \sigma>0, \alpha>0, \beta>0} 
and  \eqn{\omega = {\frac{B(\alpha,\beta)}{\sqrt{2\pi}}}{{\left(1+{\frac{\beta}{\alpha}}\right)}^{\alpha+\beta}}{\left(\frac{\beta}{\alpha}\right)}^{-\beta}}
}
\examples{
library("neodistr")
dgmsnburr(0, mu=0, sigma=1, alpha=1,beta=1)
pgmsnburr(4, mu=0, sigma=1, alpha=1, beta=1)
qgmsnburr(0.4, mu=0, sigma=1, alpha=1, beta=1)
r=rgmsnburr(10000, mu=0, sigma=1, alpha=1, beta=1)
head(r)
hist(r, xlab = 'GMSNBurr random number', ylab = 'Frequency', 
main = 'Distribution of GMSNBurr Random Number ')
}
\references{
Choir, A. S. (2020). The New Neo-Normal Distributions and their Properties. Dissertation. Institut Teknologi Sepuluh Nopember.

Iriawan, N. (2000). Computationally Intensive Approaches to Inference in Neo-Normal Linear Models. Curtin University of Technology.
}
\author{
Achmad Syahrul Choir
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
