% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFVariableL3b.R
\docType{class}
\name{CFVariableL3b}
\alias{CFVariableL3b}
\title{CF data variable for the NASA L3b format}
\description{
This class represents a CF data variable that provides access to
data sets in NASA level-3 binned format, used extensively for satellite
imagery.
}
\references{
https://oceancolor.gsfc.nasa.gov/resources/docs/technical/ocean_level-3_binned_data_products.pdf
}
\section{Super classes}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{\link[ncdfCF:CFVariable]{ncdfCF::CFVariable}} -> \code{CFVariableL3b}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFVariableL3b-new}{\code{CFVariableL3b$new()}}
\item \href{#method-CFVariableL3b-subset}{\code{CFVariableL3b$subset()}}
\item \href{#method-CFVariableL3b-clone}{\code{CFVariableL3b$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="dim"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-dim'><code>ncdfCF::CFObject$dim()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="update_coordinates_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-update_coordinates_attribute'><code>ncdfCF::CFObject$update_coordinates_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="add_auxiliary_coordinate"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-add_auxiliary_coordinate'><code>ncdfCF::CFVariable$add_auxiliary_coordinate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="add_cell_measure"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-add_cell_measure'><code>ncdfCF::CFVariable$add_cell_measure()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="append"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-append'><code>ncdfCF::CFVariable$append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="array"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-array'><code>ncdfCF::CFVariable$array()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="brief"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-brief'><code>ncdfCF::CFVariable$brief()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="data.table"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-data.table'><code>ncdfCF::CFVariable$data.table()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="detach"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-detach'><code>ncdfCF::CFVariable$detach()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="is_coincident"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-is_coincident'><code>ncdfCF::CFVariable$is_coincident()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="peek"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-peek'><code>ncdfCF::CFVariable$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="print"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-print'><code>ncdfCF::CFVariable$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="profile"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-profile'><code>ncdfCF::CFVariable$profile()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="raw"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-raw'><code>ncdfCF::CFVariable$raw()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="save"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-save'><code>ncdfCF::CFVariable$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="shard"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-shard'><code>ncdfCF::CFVariable$shard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="summarise"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-summarise'><code>ncdfCF::CFVariable$summarise()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="terra"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-terra'><code>ncdfCF::CFVariable$terra()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFVariable" data-id="time"><a href='../../ncdfCF/html/CFVariable.html#method-CFVariable-time'><code>ncdfCF::CFVariable$time()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableL3b-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableL3b-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableL3b$new(grp, units)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grp}}{The group that this CF variable lives in. Must be called
"/level-3_binned_data".}

\item{\code{units}}{Vector of two character strings with the variable name and
the physical units of the data variable in the netCDF resource.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableL3b-subset"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableL3b-subset}{}}}
\subsection{Method \code{subset()}}{
This method extracts a subset of values from the data of the
variable, with the range along both axes expressed in decimal degrees.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableL3b$subset(..., rightmost.closed = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{One or more arguments of the form \code{axis = range}. The "axis"
part should be the name of axis \code{longitude} or \code{latitude} or its
orientation \code{X} or \code{Y}. The "range" part is a vector of values
representing coordinates along the axis where to extract data. Axis
designators and names are case-sensitive and can be specified in any
order. If values for the range of an axis fall outside of the extent of
the axis, the range is clipped to the extent of the axis.}

\item{\code{rightmost.closed}}{Single logical value to indicate if the upper
boundary of range in each axis should be included.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The range of values along both axes of latitude and longitude is
expressed in decimal degrees. Any axes for which no information is
provided in the \code{subset} argument are extracted in whole. Values can be
specified in a variety of ways that should (resolve to) be a vector of
real values. A range (e.g. \code{100:200}), a vector (\verb{c(23, 46, 3, 45, 17}), a sequence (\verb{seq(from = 78, to = 100, by = 2}), all work. Note,
however, that only a single range is generated from the vector so these
examples resolve to \verb{(100, 200)}, \verb{(3, 46)}, and \verb{(78, 100)},
respectively.

If the range of values for an axis in argument \code{subset} extend the
valid range of the axis in \code{x}, the extracted slab will start at the
beginning for smaller values and extend to the end for larger values.
If the values envelope the valid range the entire axis will be
extracted in the result. If the range of \code{subset} values for any axis
are all either smaller or larger than the valid range of the axis in
\code{x} then nothing is extracted and \code{NULL} is returned.

The extracted data has the same dimensional structure as the data in
the variable, with degenerate dimensions dropped. The order of the axes
in argument \code{subset} does not reorder the axes in the result; use the
\link{CFVariable}$array() method for this.
}

\subsection{Returns}{
A \link{CFVariable} instance, having an array with axes and attributes of
the variable, or \code{NULL} if one or more of the elements in the \code{...}
argument falls entirely outside of the range of the axis. Note that
degenerate dimensions (having \code{length(.) == 1}) are dropped from the
array but the corresponding axis is maintained in the result as a
scalar axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFVariableL3b-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFVariableL3b-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFVariableL3b$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
