% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templatebrain.R
\name{templatebrain-meths}
\alias{templatebrain-meths}
\alias{is.templatebrain}
\alias{as.character.templatebrain}
\alias{print.templatebrain}
\alias{as.im3d.templatebrain}
\alias{origin.templatebrain}
\alias{dim.templatebrain}
\alias{voxdims.templatebrain}
\alias{boundingbox.templatebrain}
\title{Template brain methods}
\usage{
is.templatebrain(x)

\method{as.character}{templatebrain}(x, field = c("regName", "name"), ...)

\method{print}{templatebrain}(x, ...)

\method{as.im3d}{templatebrain}(x, ...)

\method{origin}{templatebrain}(x, ...)

\method{dim}{templatebrain}(x, ...)

\method{voxdims}{templatebrain}(x, ...)

\method{boundingbox}{templatebrain}(x, ...)
}
\arguments{
\item{x}{an object (usually a \code{templatebrain}).}

\item{field}{which field to use (defaults to \code{'regName'}).}

\item{...}{additional arguments for methods.}
}
\value{
Return values are documented in the generic methods.
  \code{is.templatebrain} returns a logical indicating whether or not the
  object is a \code{templatebrain}.

\code{as.character.templatebrain} returns a character vector with the
  name of the template brain.

\code{dim.templatebrain} returns a 3-value integer vector.
}
\description{
\code{is.templatebrain} tests if object is of class
  templatebrain

\code{as.character.templatebrain} converts template brain to
  character vector representation (normally used to extract the short name
  i.e. \code{regName}).

\code{print.templatebrain} prints templatebrain information in
  human-readable form

\code{as.im3d} converts a template brain to a
  \code{nat::\link[nat]{im3d}} object; this is probably useful for
  developers.

\code{origin} extracts the space origin of a \code{templatebrain}
  object.

\code{dim} extracts the dimensions (in number of pixels) of the
  image associated with a \code{templatebrain} object.

\code{voxdims} extracts the dimensions (in calibrated spatial
  units, e.g. microns) of voxels in the image associated with a
  \code{templatebrain} object.

\code{boundingbox} extracts the boundingbox (in calibrated
  spatial units, e.g. microns) of the image associated with a templatebrain
  object. See \code{\link[nat]{boundingbox}} for details.
}
\examples{
data(FCWB.demo)
is.templatebrain(FCWB.demo)
origin(FCWB.demo)
dim(FCWB.demo)
voxdims(FCWB.demo)
boundingbox(FCWB.demo)
# print method
FCWB.demo
}
\seealso{
\code{\link[nat]{im3d}}

\code{\link[nat]{origin}}

\code{\link[nat]{voxdims}}

\code{\link[nat]{boundingbox}}
}
