% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvgam-class.R
\name{mvgam-class}
\alias{mvgam-class}
\title{Fitted \code{mvgam} object description}
\description{
A fitted \code{mvgam} object returned by function \code{\link{mvgam}}.
Run \code{methods(class = "mvgam")} to see an overview of available methods.
}
\details{
A \code{mvgam} object contains the following elements:
\itemize{
\item \code{call} the original observation model formula
\item \code{trend_call} If a \verb{trend_formula was supplied}, the original trend model
formula is returned. Otherwise \code{NULL}
\item \code{family} \code{character} description of the observation distribution
\item \code{trend_model} \code{character} description of the latent trend model
\item \code{trend_map} \code{data.frame} describing the mapping of trend states to
observations, if supplied in the original model. Otherwise \code{NULL}
\item \code{drift} Logical specifying whether a drift term was used in the trend
model
\item \code{priors} If the model priors were updated from their defaults, the prior
\code{dataframe} will be returned. Otherwise \code{NULL}
\item \code{model_output} The \code{MCMC} object returned by the fitting engine. If the
model was fitted using \code{Stan}, this will be an object of class \code{stanfit}
(see \code{\link[rstan]{stanfit-class}} for details). If \code{JAGS} was used
as the backend, this will be an object of class \code{runjags} (see
\code{\link[runjags]{runjags-class}} for details)
\item \code{model_file} The \code{character} string model file used to describe the model
in either \code{Stan} or \code{JAGS} syntax
\item \code{model_data} If \code{return_model_data} was set to \code{TRUE} when fitting the
model, the \code{list} object containing all data objects needed to condition
the model is returned. Each item in the \code{list} is described in detail at
the top of the \code{model_file}. Otherwise \code{NULL}
\item \code{inits} If \code{return_model_data} was set to \code{TRUE} when fitting the model,
the initial value functions used to initialise the MCMC chains will be
returned. Otherwise \code{NULL}
\item \code{monitor_pars} The parameters that were monitored during MCMC sampling
are returned as a \verb{character vector}
\item \code{sp_names} A \verb{character vector} specifying the names for each smoothing
parameter
\item \code{mgcv_model} An object of class \code{gam} containing the \code{mgcv} version of
the observation model. This object is used for generating the linear
predictor matrix when making predictions for new data. The coefficients
in this model object will contain the posterior median coefficients from
the GAM linear predictor, but these are only used if generating plots of
smooth functions that \code{mvgam} currently cannot handle (such as plots for
three-dimensional smooths). This model therefore should not be used for
inference. See \code{\link[mgcv]{gamObject}} for details
\item \code{trend_mgcv_model} If a \verb{trend_formula was supplied}, an object of class
\code{gam} containing the \code{mgcv} version of the trend model. Otherwise \code{NULL}
\item \code{ytimes} The \code{matrix} object used in model fitting for indexing which
series and timepoints were observed in each row of the supplied data.
Used internally by some downstream plotting and prediction functions
\item \code{resids} A named \code{list} object containing posterior draws of Dunn-Smyth
randomized quantile residuals
\item \code{use_lv} Logical flag indicating whether latent dynamic factors were used
in the model
\item \code{n_lv} If \code{use_lv == TRUE}, the number of latent dynamic factors used in
the model
\item \code{upper_bounds} If bounds were supplied in the original model fit, they
will be returned. Otherwise \code{NULL}
\item \code{obs_data} The original data object (either a \code{list} or \code{dataframe})
supplied in model fitting.
\item \code{test_data} If test data were supplied (as argument \code{newdata} in the
original model), it will be returned. Othwerise \code{NULL}
\item \code{fit_engine} \code{Character} describing the fit engine, either as \code{stan} or
\code{jags}
\item \code{backend} \code{Character} describing the backend used for modelling, either
as \code{rstan}, \code{cmdstanr} or \code{rjags}
\item \code{algorithm} \code{Character} describing the algorithm used for finding the
posterior, either as \code{sampling}, \code{laplace}, \code{pathfinder}, \code{meanfield} or
\code{fullrank}
\item \code{max_treedepth} If the model was fitted using \code{Stan}, the value supplied
for the maximum treedepth tuning parameter is returned (see
\code{\link[rstan]{stan}} for details). Otherwise \code{NULL}
\item \code{adapt_delta} If the model was fitted using \code{Stan}, the value supplied
for the adapt_delta tuning parameter is returned (see
\code{\link[rstan]{stan}} for details). Otherwise \code{NULL}
}
}
\seealso{
\link{mvgam}
}
\author{
Nicholas J Clark
}
