% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_branch.R
\name{add_formula_branch}
\alias{add_formula_branch}
\title{Add formula branches to a \code{mverse} object.}
\usage{
add_formula_branch(.mverse, br)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}

\item{br}{a \code{formula_branch} object.}
}
\value{
The resulting \code{mverse} object.
}
\description{
This method adds a formula branch to an existing \code{mverse} object.
A formula branch is used to specify model structure options for the
analysis.
}
\examples{
# Define a formula branch.
model_specifications <- formula_branch(
  y ~ MasFem,
  y ~ MasFem + hurricane_strength,
  y ~ MasFem * hurricane_strength
)
# Create a mverse, add the branch.
mv <- create_multiverse(hurricane) \%>\%
  add_formula_branch(model_specifications)
}
\seealso{
Other formula branch functions: 
\code{\link{formula_branch}}
}
\concept{formula branch functions}
