% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/howfree.R
\name{howfree}
\alias{howfree}
\title{Count a scale's degrees of freedom}
\usage{
howfree(set, ineqmat = NULL, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to "white," "black", "gray", "roth", "pastel," or "rosy",
giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}}, \code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}},
\code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, and \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}}. For other
arrangements, the desired inequality matrix can be entered directly.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Single non-negative integer
}
\description{
Some scalar structures can vary their specific pitches much more flexibly
than others while retaining the same overall "color." For instance, the
meantone family of diatonic scales is generated by a line of fifths and
can only vary along one dimension: the size of the generating fifth.
This literally defines a line in the MCT geometry, and if the scale moves
off that line it ceases to have the same structure as the diatonic scale.
(Notably, it stops being non-degenerate well-formed.) By contrast, the
5-limit just diatonic scale is defined by two distinct parameters: the
size of its major third and the size of its perfect fifth. See "Modal
Color Theory," pp. 26-27, for more discussion.
}
\examples{
c_natural_minor <- c(0, 2, 3, 5, 7, 8, 10)
c_melodic_minor <- c(0, 2, 3, 5, 7, 9, 11)
just_diatonic <- j(dia)
howfree(c_natural_minor)
howfree(c_melodic_minor)
howfree(just_diatonic)

howfree(c(0, 4, 7))
howfree(c(0, 4, 7), ineqmat="white")

howfree(c(0, 2, 6), ineqmat="mct")
howfree(c(0, 2, 6), ineqmat="roth")

}
