% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpunique.R
\name{fpunique}
\alias{fpunique}
\title{Unique real values up to some tolerance}
\usage{
fpunique(x, MARGIN = 0, rounder = 10)
}
\arguments{
\item{x}{Numeric array whose unique elements are to be determined}

\item{MARGIN}{Numeric \code{0}, \code{1}, or \code{2} depending on whether you want
unique individual numbers, unique rows, or unique columns, respectively.
Defaults to \code{0}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric array of unique elements (vector if \code{MARGIN} is 0;
matrix otherwise)
}
\description{
Working with scales in continuous pitch space, many pitches and intervals
are irrationals represented as \strong{f}loating \strong{p}oint numbers. This can cause
arithmetic and rounding errors, leading to it looking like there are
more distinct pitches/intervals in the set than there really are. Use
\code{fpunique} rather than \code{\link[base:unique]{base::unique()}} whenever you handle scales in continuous
pitch space.
}
\details{
Sometimes you may need to adjust the tolerance (\code{rounder}) to get correct
results, especially if you have done several operations in a row which
may have introduced rounding errors.
}
\examples{
just_dia <- j(dia)
intervals_in_just_dia <- sort(as.vector(sim(just_dia)))
failed_unique_intervals <- unique(intervals_in_just_dia)
fpunique_intervals <- fpunique(intervals_in_just_dia)
length(failed_unique_intervals)
length(fpunique_intervals)
}
