% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals_and_scales.R
\name{edoo}
\alias{edoo}
\title{Perfectly even scales (the color white)}
\usage{
edoo(card, edo = 12)
}
\arguments{
\item{card}{Number of notes in the scale. Numeric.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
Numeric vector of length \code{card} representing a scale of \code{card} notes.
}
\description{
Creates a perfectly even scale that divides the octave into n equal steps.
Such scales serve as the origin for the hyperplane arrangements of Modal Color Theory,
whence the name \code{edoo} for "\strong{e}qual \strong{d}ivision of the \strong{o}ctave \strong{o}rigin."
}
\examples{
edoo(5)
edoo(5, edo=15)
octatonic_scale <- tc(edoo(4), c(0, 1))
print(octatonic_scale)
}
