% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack-multiverse.R
\name{reveal_model_parameters}
\alias{reveal_model_parameters}
\title{Reveal the model parameters of a multiverse analysis}
\usage{
reveal_model_parameters(.multi, effect_key = NULL, .unpack_specs = "no")
}
\arguments{
\item{.multi}{a multiverse list-column \code{tibble} produced by
\code{\link{run_multiverse}}.}

\item{effect_key}{character, if you added parameter keys to your pipeline,
you can specify if you would like filter the parameters using one of your
parameter keys. This is useful when different variables are being switched
out across the multiverse but represent the same effect of interest.}

\item{.unpack_specs}{character, options are \code{"no"}, \code{"wide"}, or
\code{"long"}. \code{"no"} (default) keeps specifications in a list column,
\code{wide} unnests specifications with each specification category as a
column. \code{"long"} unnests specifications and stacks them into long
format, which stacks specifications into a \code{decision_set} and
\code{alternatives} columns. This is mainly useful for plotting.}
}
\value{
the unnested model paramerters from the multiverse.
}
\description{
Reveal the model parameters of a multiverse analysis
}
\examples{

library(tidyverse)
library(multitool)

# Simulate some data
the_data <-
  data.frame(
    id   = 1:500,
    iv1  = rnorm(500),
    iv2  = rnorm(500),
    iv3  = rnorm(500),
    mod1 = rnorm(500),
    mod2 = rnorm(500),
    mod3 = rnorm(500),
    cov1 = rnorm(500),
    cov2 = rnorm(500),
    dv1  = rnorm(500),
    dv2  = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

# Decision pipeline
full_pipeline <-
  the_data |>
  add_filters(include1 == 0,include2 != 3,include2 != 2,scale(include3) > -2.5) |>
  add_variables("ivs", iv1, iv2, iv3) |>
  add_variables("dvs", dv1, dv2) |>
  add_variables("mods", starts_with("mod")) |>
  add_model("linear_model", lm({dvs} ~ {ivs} * {mods} + cov1))

pipeline_grid <- expand_decisions(full_pipeline)

# Run the whole multiverse
the_multiverse <- run_multiverse(pipeline_grid[1:10,])

# Reveal results of the linear model
the_multiverse |>
  reveal_model_parameters()
}
