% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_scale.raster.R
\name{kernel_scale.raster}
\alias{kernel_scale.raster}
\title{Create scaled rasters}
\usage{
kernel_scale.raster(
  raster_stack,
  sigma = NULL,
  multiScaleR = NULL,
  shape = NULL,
  kernel = c("gaussian", "exp", "expow", "fixed"),
  pct_wt = 0.975,
  fft = TRUE,
  scale_center = FALSE,
  clamp = FALSE,
  pct_mx = 0,
  na.rm = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{raster_stack}{Stack of combined `SpatRaster` layers}

\item{sigma}{Vector of parameters listed in order to scale each raster}

\item{multiScaleR}{If scale optimization with `multimultiScaleRim` has been completed, provide the `multiscaleR` object here. You can also pass an object of class "multiScaleR_data" created using `kernel_prep`.  Default: NULL}

\item{shape}{Vector of parameters listed in order to scale each raster if using 'expow' kernel. Default: NULL}

\item{kernel}{Kernel function to be used ('gaussian', 'exp', 'fixed', 'expow'; Default: 'gaussian')}

\item{pct_wt}{The percentage of the weighted density to include when applying the kernel smoothing function, Default: 0.975}

\item{fft}{Logical. If TRUE (Default), a fast Fourier transformation will be used to smooth the raster surface. See details.}

\item{scale_center}{Logical. If `TRUE`, raster values are scaled and centered accordingly to the data used to fit the model. Necessary when predicting model results across the landscape.}

\item{clamp}{Logical. If `TRUE`, scaled values are clamped to the covariate range in the model data.}

\item{pct_mx}{Numeric. If `clamp` is `TRUE`, this value specifies the amount (percentage; positive or negative) by which to expand/contract the min/max range when clamping. Can range from -0.99–0.99 (Default = 0).}

\item{na.rm}{Logical. If TRUE (Default), NA values are removed from the weighted mean calculation.}

\item{verbose}{Logical. Print status of raster scaling to the console. Default: TRUE}

\item{...}{Not used}
}
\value{
`SpatRaster` object containing scaled rasters
}
\description{
Function to create scaled rasters
}
\details{
The fast Fourier transformation is substantially faster when scaling large raster surfaces with large kernel areas. There will be some edge effects on the outer boundaries.
}
\examples{
## Not Run
r1 <- rast(matrix(rnorm(25^2),
                  nrow = 25))

r1_s <- kernel_scale.raster(r1,
                            sigma = 4,
                            kernel = 'gaussian')
plot(c(r1, r1_s))


}
