% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtscr.R
\name{mtscr}
\alias{mtscr}
\title{Create MTS model}
\usage{
mtscr(
  df,
  id_column,
  score_column,
  item_column = NULL,
  top = 1,
  ties_method = c("random", "average"),
  normalise = TRUE,
  self_ranking = NULL
)
}
\arguments{
\item{df}{Data frame in long format.}

\item{id_column}{Name of the column containing participants' id.}

\item{score_column}{Name of the column containing divergent thinking scores
(e.g. semantic distance).}

\item{item_column}{Optional, name of the column containing distinct trials
(e.g. names of items in AUT).}

\item{top}{Integer or vector of integers (see examples), number of top answers
to prepare indicators for. Default is 1, i.e. only the top answer.}

\item{ties_method}{Character string specifying how ties are treated when
ordering. Can be \code{"average"} (better for continuous scores like semantic
distance) or \code{"random"} (default, better for ratings). See \code{\link[=rank]{rank()}} for details.}

\item{normalise}{Logical, should the creativity score be normalised? Default is \code{TRUE} and
it's recommended to leave it as such.}

\item{self_ranking}{Name of the column containing answers' self-ranking.
Provide if model should be based on top answers self-chosen by the participant.
Every item should have its own ranks. The top answers should have a value of 1,
and the other answers should have a value of 0. In that case, the \code{top} argument
doesn't change anything and should be left as \code{top = 1}. \code{ties_method} is not used if \code{self_ranking}
was provided. See \link{mtscr_self_rank} for example.}
}
\value{
The return value depends on length of the \code{top} argument. If \code{top} is a single
integer, a \code{mtscr} model is returned. If \code{top} is a vector of integers, a \code{mtscr_list} object
is returned, with names corresponding to the \code{top} values, e.g. \code{top1}, \code{top2}, etc.
}
\description{
Create MTS model for creativity analysis. Use with \code{\link[=summary.mtscr]{summary.mtscr()}} and \code{\link[=predict.mtscr]{predict.mtscr()}}.
}
\examples{
data("mtscr_creativity", package = "mtscr")

mtscr_creativity <- mtscr_creativity |>
  dplyr::slice_sample(n = 500) # for performance, ignore

# single model for top 1 answer
mtscr(mtscr_creativity, id, SemDis_MEAN, item) |>
  summary()

# three models for top 1, 2, and 3 answers
fit3 <- mtscr(
  mtscr_creativity,
  id,
  SemDis_MEAN,
  item,
  top = 1:3,
  ties_method = "average"
)

# add the scores to the database
predict(fit3)

# get the socres only
predict(fit3, minimal = TRUE)

}
\seealso{
\itemize{
\item \code{\link[=summary.mtscr]{summary.mtscr()}} for the fit measures of the model.
\item \code{\link[=predict.mtscr]{predict.mtscr()}} for getting the scores.
}
}
