% lwc-30-01-2007: First draft
%
\name{maccest}
\alias{maccest}
\alias{maccest.formula}
\alias{maccest.default}
\alias{print.maccest}
\alias{summary.maccest}
\alias{print.summary.maccest}

\title{Estimation of Multiple Classification Accuracy}

% ------------------------------------------------------------------------
\description{
  Estimation of classification accuracy by multiple classifiers with
  resampling procedure and comparisons of multiple classifiers.
}

% ------------------------------------------------------------------------
\usage{
maccest(dat, \dots)
\method{maccest}{default}(dat, cl, method="svm", pars = valipars(), 
        tr.idx = NULL, comp="anova",\dots) 
\method{maccest}{formula}(formula, data = NULL, \dots, subset, na.action = na.omit)
}

% ------------------------------------------------------------------------
\arguments{
  \item{formula}{
    A formula of the form \code{groups ~ x1 + x2 + \dots}  That is, the
    response is the grouping factor and the right hand side specifies
    the (non-factor) discriminators.
  }

  \item{data}{
    Data frame from which variables specified in \code{formula} are
    preferentially to be taken.
  }
  
  \item{dat}{
    A matrix or data frame containing the explanatory variables if no
    formula is given as the principal argument.
  }
  
  \item{cl}{
    A factor specifying the class for each observation if no formula
    principal argument is given.
  }
  
  \item{method}{
    A vector of multiple classification methods to be used. Classifiers,
    such as \code{randomForest}, \code{svm}, \code{knn} and \code{lda},
    can be used. For details, see \code{note} below.
 
  }
  
  \item{pars}{
    A list of resampling scheme such as \emph{Leave-one-out
    cross-validation}, \emph{Cross-validation}, \emph{Randomised
    validation (holdout)} and \emph{Bootstrap}, and control parameters
    for the calculation of accuracy. See \code{\link{valipars}} for
    details.
  }
  
  \item{tr.idx}{
    User defined index of training samples. Can be generated by
    \code{trainind}.
  }

  \item{comp}{
    Comparison method of multiple classifier. If \code{comp} is
    \code{anova}, the multiple comparisons are performed by \code{ANOVA}
    and then the pairwise comparisons are performed by \code{HSDTukey}. If
    \code{comp} is \code{fried}, the multiple comparisons are performed by
    \code{Friedman Test} and the pairwise comparisons are performed by
    \code{Wilcoxon Test}.
  }

  \item{\dots}{Additional parameters to \code{method}.}
  
  \item{subset}{
    Optional vector, specifying a subset of observations to be used.
  }
  
  \item{na.action}{
    Function which indicates what should happen when the data
    contains \code{NA}'s, defaults to \code{\link{na.omit}}.
  } 
}

% ---------------------------------------------------------------------
\details{
  The accuracy rates for classification are obtained used techniques
  such as \emph{Random Forest}, \emph{Support Vector Machine},
  \emph{k-Nearest Neighbour Classification}, \emph{Linear Discriminant
  Analysis} and \emph{Linear Discriminant Analysis} based on sampling
  methods, including \emph{Leave-one-out cross-validation},
  \emph{Cross-validation}, \emph{Randomised validation (holdout)} and
  \emph{Bootstrap}.
}

% --------------------------------------------------------------------
\note{
  The \code{maccest} can take any classification model if its argument
  format is \code{model(formula, data, subset, na.action, ...)} and
  their corresponding method \code{predict.model(object, newdata, ...)}
  can either return the only predicted class label or in a list with
  name as \code{class}, such as \code{lda} and \code{pcalda}.
  
  As for the multiple comparisons by \code{ANOVA}, the following
  assumptions should be considered:
  \itemize{
    \item The samples are randomly and independently selected.
    \item The populations are normally distributed.
    \item The populations  all have the same variance.
  }
  
  All the comparisons are based on the results of all iteration.
  
  \code{\link{aam.mcl}} is a simplified version which returns \code{acc}
	(accuracy), \code{auc}(area under ROC curve) and \code{mar}(class
	margin).

}

% ---------------------------------------------------------------------
\value{
  An object of class \code{maccest}, including the components:
  \item{method}{Classification method used.}
  \item{acc}{Accuracy rate.}
  \item{acc.iter}{Accuracy rate of each iteration.}
  \item{acc.std}{Standard derivation of accuracy rate.}
  \item{mar}{Prediction margin.}
  \item{mar.iter}{Prediction margin of each iteration.}
  \item{auc}{The area under receiver operating curve (AUC).}
  \item{auc.iter}{AUC of each iteration.}
  \item{comp}{Multiple comparison method used.}
  \item{h.test}{Hypothesis test results of multiple comparison.}
  \item{gl.pval}{Global or overall p-value.}
  \item{mc.pval}{Pairwise comparison p-values.}
  \item{sampling}{Sampling scheme used.} 
  \item{niter}{Number of iteration.}
  \item{nreps}{Number of replications in each iteration. }
  \item{conf.mat}{Overall confusion matrix.}
  \item{acc.boot}{ A list of bootrap error such as \code{.632} and \code{.632+}
    if the validation method is bootrap. 
  } 
}

% -----------------------------------------------------------------------
\author{
  Wanchang Lin 
}

\seealso{
  \code{\link{accest}}, \code{\link{aam.mcl}}, \code{\link{valipars}},
  \code{\link{plot.maccest}} \code{\link{trainind}},
  \code{\link{boxplot.maccest}},\code{\link{classifier}} }

% -----------------------------------------------------------------------
\examples{
# Iris data
data(iris)
x      <- subset(iris, select = -Species)
y      <- iris$Species

method <- c("randomForest","svm","pcalda","knn")
pars   <- valipars(sampling="boot", niter = 3, nreps=5, strat=TRUE)
res    <- maccest(Species~., data = iris, method=method, pars = pars, 
                  comp="anova")
## or 
res    <- maccest(x, y, method=method, pars=pars, comp="anova") 

res
summary(res)
plot(res)
boxplot(res)
oldpar <- par(mar = c(5,10,4,2) + 0.1)
plot(res$h.test$tukey,las=1)   ## plot the tukey results
par(oldpar)
}

\keyword{classif}
