% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{solversettings}
\alias{solversettings}
\title{Optional inputs for lsoda}
\description{
These are settings for the differential equation 
solver (\code{lsoda}) that can be accessed via
the R interface.  The code listing below is taken directly
from the \code{lsoda} source code.
}
\details{
The following items can be set

\itemize{
\item \code{hmax} (\code{HMAX} below); decrease \code{hmax} when 
you want to limit how big of a step the solver can take when 
integrating from one time to the next time. However be aware
that smaller \code{hmax} will result in longer run times.
\item \code{hmin} (\code{HMIN} below); don't fiddle with this
unless you know what you're doing.  
\item \code{ixpr} (\code{IXPR} below)
\item \code{maxsteps} (\code{MXSTEP} below); increase this 
number when the solver has a long interval between 
two integration times (e.g. when observation records are 
far apart). 
\item \code{mxhnil} (\code{MXHNIL below}); don't usually 
modify this one
\item \code{atol} - the absolute solver tolerance; decrease
this number (e.g. to 1E-10 or 1E-20 or 1E-50) when the 
value in a compartment can get extremely small; without this 
extra (lower) tolerance, the value can get so low that the number
can randomly become negative.  However be aware that more precision
here will result in longer run times. 
\item \code{rtol} - the relative solver tolerances; decrease this 
number when you want a more precise solution.  However be aware 
that more precision here will result in longer run times.
}
}
\seealso{
\code{\link{aboutsolver}}, \code{\link[mrgsolve]{update}}
}
