% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwrite.R
\name{mwrite_yaml}
\alias{mwrite_yaml}
\title{Write model code to yaml  format}
\usage{
mwrite_yaml(x, file, digits = 8)
}
\arguments{
\item{x}{a model object.}

\item{file}{output file name; if non-character (e.g., \code{NULL}), no output
will be written to file.}

\item{digits}{precision to use when writing outputs.}
}
\value{
A list containing data that was written out to the yaml file, with added
item \code{file}, is returned invisibly.
}
\description{
Model code is written to a readable, transport format. This transport format
can be useful for (1) breaking connection to NONMEM modeling outputs that
are imported by \verb{$NMXML} or \verb{$NMEXT} and (2) saving model updates (e.g.,
an updated parameter list). Models can be read back using \code{\link[=mread_yaml]{mread_yaml()}} or
converted to mrgsolve cpp format with \code{\link[=yaml_to_cpp]{yaml_to_cpp()}}.
}
\details{
Parameters and omega and sigma matrices that were imported via \verb{$NMXML}
or \verb{$NMEXT} will be written into the yaml file and the NONMEM import blocks
will be dropped. This allows the user to load a model based on a NONMEM run
without having a connection to that output (e.g., \code{root.xml} or \code{root.ext}).
Given that the connection to the NONMEM modeling outputs is broken when
writing to yaml, any update to the NONMEM run will only be propagated to
the yaml file when \code{mwrite_yaml()} is run again.

The yaml file does not currently have the ability to track
other external dependencies, such as user-defined header files or other
code that might be sourced in by the user when the model is loaded via
\code{\link[=mread]{mread()}}. NONMEM xml and ext files imported by \verb{$NMXML} or \verb{$NMEXT} are
the \emph{only} external dependencies that are accounted for in the yaml
transport file.
}
\examples{
mod <- house()

temp1 <- tempfile(fileext = ".yaml")

x <- mwrite_yaml(mod, temp1)

readLines(temp1)

}
\seealso{
\code{\link[=mread_yaml]{mread_yaml()}}, \code{\link[=yaml_to_cpp]{yaml_to_cpp()}}
}
