% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{ev_repeat}
\alias{ev_repeat}
\title{Repeat a block of dosing events}
\usage{
ev_repeat(x, n, wait = 0, as.ev = FALSE)
}
\arguments{
\item{x}{event object or dosing data frame.}

\item{n}{number of times to repeat.}

\item{wait}{time to wait between repeats.}

\item{as.ev}{if \code{TRUE}, an event object is returned; otherwise a data.frame
is returned.}
}
\value{
See \code{as.ev} argument.
}
\description{
Repeat a block of dosing events
}
\examples{
e1 <- ev(amt = 100, ii = 24, addl = 20)
e4 <- ev_repeat(e1, n = 4, wait = 168)
mod <- mrgsolve::house()
out <- mrgsim(mod, events = e4, end = 3200)
plot(out, "CP")

}
