% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.View}
\alias{subset.View}
\title{Subset a View}
\usage{
\method{subset}{View}(x, expr = NULL, data_points = NULL, columns = NULL, by = NULL, ...)
}
\arguments{
\item{x}{\code{View} object}

\item{expr}{an R expression to subset time or other variables.}

\item{data_points}{body part in the data e.g. 'Nose'.}

\item{columns}{column name in the data e.g. 'Nose_x'.}

\item{by}{increment of the sequence of rows to return.}

\item{...}{unused.}
}
\value{
a \code{View} object.
}
\description{
Simple time and column subsetting of views.
}
\examples{
r <- get_sample_recording()
v <- get_raw_view(r, "Central", "", "Sitar")
vv <- subset(v, Time < 10, data_point = "Nose")
plot(vv)
}
