% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{splice_time.Duration}
\alias{splice_time.Duration}
\title{Generate spliced timeline using a Duration object}
\usage{
\method{splice_time}{Duration}(
  x,
  expr = NULL,
  make.unique = TRUE,
  tier = NULL,
  comments = NULL,
  ...
)
}
\arguments{
\item{x}{\code{Duration} object.}

\item{expr}{R expression to filter data on.}

\item{make.unique}{make the segments unique? (Default is TRUE).}

\item{tier}{exact tier name to filter on.}

\item{comments}{exact comment to filter on.}

\item{...}{passed to \code{\link[=make.unique]{make.unique()}}}
}
\value{
a \code{Splice} object.
}
\description{
Generate spliced timeline using a Duration object
}
\examples{
r <- get_sample_recording()
d <- get_duration_annotation_data(r)
splice_time(d, tier = 'Event', comments = 'tabla solo')
}
\seealso{
Other splicing functions: 
\code{\link{clip_splice}()},
\code{\link{get_spliced_view}()},
\code{\link{is_splice_overlapping}()},
\code{\link{merge_splice}()},
\code{\link{splice_time}()},
\code{\link{splice_time.Metre}()},
\code{\link{splice_time.OnsetsDifference}()},
\code{\link{splice_time.View}()},
\code{\link{splice_time.list}()},
\code{\link{split.SplicedView}()}
}
\concept{splicing functions}
