% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granger.R
\name{ms_condgrangertest}
\alias{ms_condgrangertest}
\title{Test for Conditional Granger Causality}
\usage{
ms_condgrangertest(x, y, z, order = 1, na.action = stats::na.omit, ...)
}
\arguments{
\item{x}{response vector of observations.}

\item{y}{explanatory vector of observations.}

\item{z}{conditioning vector of observations}

\item{order}{number of lags (in frames).}

\item{na.action}{a function for eliminating NAs after aligning the series x and y.}

\item{...}{passed to \code{\link[lmtest:waldtest]{lmtest::waldtest()}}.}
}
\value{
Anova object
}
\description{
Faster implementation of the vector version of  \code{\link[lmtest:grangertest]{lmtest::grangertest()}} with
conditioning on the \emph{history} of a third variable. The function assumes time
series always have the same start date and periodicity, which is true for the data in this
package.
}
\examples{
data(wages, package = "lmtest")
diff_wages <- diff(wages)

# Granger tests
lmtest::grangertest(diff_wages[, 'w'], diff_wages[, 'CPI'], order = 3)
ms_grangertest1(diff_wages[, 'w'], diff_wages[, 'CPI'], order = 3)
ms_grangertest2(diff_wages[, 'w'], diff_wages[, 'CPI'], order = 3)

ms_condgrangertest(diff_wages[, 'w'], diff_wages[, 'CPI'], diff_wages[, 'u'], order = 3)
}
\seealso{
Other Granger Causality: 
\code{\link{autoplot.GrangerTime}()},
\code{\link{get_granger_interactions}()},
\code{\link{granger_test}()},
\code{\link{map_to_granger_test}()},
\code{\link{ms_grangertest1}()},
\code{\link{ms_grangertest2}()},
\code{\link{plot.GrangerInteraction}()},
\code{\link{plot_influence_diagram}()}
}
\concept{Granger Causality}
