% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_main.R
\name{md_plot}
\alias{md_plot}
\title{Visualize study design outputs}
\usage{
md_plot(
  obj,
  ci = 0.95,
  method = "HDI",
  pal = c("#007d80", "#A12C3B"),
  m = NULL
)
}
\arguments{
\item{obj}{A \code{movedesign_output} object, as returned by
\code{\link[=md_replicate]{md_replicate()}}. The object must contain a
\code{summary} data frame with, at a minimum, the following columns:
\describe{
\item{error}{Relative error values for each replicate.}
\item{error_lci}{Lower credible interval bound for error.}
\item{error_uci}{Upper credible interval bound for error.}
\item{group}{(Optional) Group label for comparing densities.}
}}

\item{ci}{Numeric scalar between 0 and 1. The probability of the
credible interval (CI) to be estimated. Default to \code{0.95} (95\%).}

\item{method}{Character. Credible interval estimation method (passed
to \code{bayestestR::ci()}; default: \code{"HDI"}). See \code{?bayestestR::ci()}
for more details.}

\item{pal}{Character vector of color(s) for the density, CI shading,
and mean line. If a single group, supply one color (default:
\code{"#007d80"}). If groups are present, supply two colors (default:
\code{c("#007d80", "#A12C3B")}).}

\item{m}{Numeric (optional). If provided, restricts the
results for a specific population sample size (\code{m}).
Defaults to \code{NULL}, which checks up to the maximum population
sample size.}
}
\value{
A \code{ggplot} object showing:
\itemize{
\item Density curve(s) of the relative error distribution.
\item Shaded region for the central credible interval.
\item Vertical dashed lines at mean(s).
\item Overlaid densities if multiple groups are present.
\item Percent-formatted x-axis for interpretation.
}

This object can be further customized with additional \code{ggplot2}
layers if needed.
}
\description{
Produces a publication-ready density plot showing the distribution of
relative error estimates from study design simulations. The plot
highlights the mean and a shaded credible interval (CI) region,
following the computation of credible intervals as implemented in
\code{bayestestR::ci()}. If groups are present, density curves for each
group are overlaid for comparison, using customizable colors.

This function is typically used after running \code{\link[=md_replicate]{md_replicate()}},
providing a visual diagnostic of simulation results.
}
\details{
This plot helps users assess the reliability of simulation outputs
by visualizing the distribution of relative errors. When multiple
groups are simulated, the plot enables direct visual comparison
of performance across groups. If credible intervals cannot be
calculated, a warning is issued and only the density curves
are displayed.

\strong{It is strongly recommended to use \code{\link[=md_check]{md_check()}} to assess whether
the distributions shown here have stabilized.} Checking for
convergence ensures that the summary statistics and uncertainty
estimates depicted in the plot are reliable and not unduly
influenced by too few replicates or ongoing variability.
Running \code{\link[=md_check]{md_check()}} helps you determine if additional simulation
replicates are needed to achieve stable inference in your design
evaluation.
}
\examples{
if (interactive()) {
  input <- md_prepare(
    data = buffalo,
    models = models,
    species = "buffalo",
    n_individuals = 5,
    dur = list(value = 1, unit = "month"),
    dti = list(value = 1, unit = "day"),
    add_individual_variation = TRUE,
    grouped = TRUE,
    set_target = "hr",
    which_meta = "mean"
  )

  output <- md_replicate(input, n_replicates = 20)

  # Plot with 80\% credible intervals:
  md_plot(output, ci = 0.80, method = "HDI")
}

}
\seealso{
\code{\link[=md_replicate]{md_replicate()}},
\code{\link[=md_check]{md_check()}} for convergence diagnostics,
and refer to \code{bayestestR::ci()} for details on credible interval
computation and interpretation.
}
