% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation_func.R
\name{evaluation}
\alias{evaluation}
\title{Measures of comparison for move plot 3}
\usage{
evaluation(bp, centring = TRUE)
}
\arguments{
\item{bp}{biplot object from \code{moveEZ}}

\item{centring}{logical argument to apply centring or not (default is \code{TRUE})}
}
\value{
\item{eval.list}{Returns a list containing the measures of comparison for each level of the time variable.}
\item{fit.plot}{Returns a line plot with the fit measures that are bounded between zero and one: PS and CC. A small PS value and large CC value indicate good fit.}
\item{bias.plot}{Returns a line plot with bias measures taht are unbounded: AMB, MB and RMSB. Small values indicate low bias.}
}
\description{
This function calculates measures of comparison after generalised orthogonal Procrustes Analysis
is performed in \code{moveplot3}. Orthogonal Procrustes Analysis is used to compare a target to a testee configuration.
The following measures are calculate: Procrustes Statistic (PS), Congruence Coefficient (CC), Absolute Mean Bias (AMB),
Mean Bias (MB) and Root Mean Squared Bias (RMSB).
}
\examples{
data(Africa_climate)
data(Africa_climate_target)
bp <- biplotEZ::biplot(Africa_climate, scaled = TRUE) |> biplotEZ::PCA()
results <- bp |> moveplot3(time.var = "Year", group.var = "Region", hulls = TRUE,
move = FALSE, target = NULL) |> evaluation()
results$eval.list
results$fit.plot
results$bias.plot

data(Africa_climate)
data(Africa_climate_target)
bp <- biplotEZ::biplot(Africa_climate, scaled = TRUE) |> biplotEZ::PCA()
results <- bp |> moveplot3(time.var = "Year", group.var = "Region", hulls = TRUE,
move = FALSE, target = Africa_climate_target) |> evaluation()
results$eval.list
results$fit.plot
results$bias.plot

}
