% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsp_to_dist.R
\name{lsp_to_dist}
\alias{lsp_to_dist}
\title{Calculate Distance Matrix}
\usage{
lsp_to_dist(x, dist_fun, unit = "log2", p = NULL)
}
\arguments{
\item{x}{An object of class \code{lsp} - usually the output of
the \code{lsp_signature()} function}

\item{dist_fun}{A distance/dissimilarity method used.
All possible values can be found using
the \code{\link[philentropy:getDistMethods]{philentropy::getDistMethods()}} function}

\item{unit}{A character string specifying the logarithm unit
that should be used to compute distances that depend on log computations:
\verb{"log", "log2", "log10"}.
The default is \code{"log"}}

\item{p}{Power of the Minkowski distance.
Used only when the \code{dist_fun = "minkowski"}}
}
\value{
An object of class `"dist"``
}
\description{
Calculates a distance matrix based on an object of class \code{lsp}.
}
\examples{
library(stars)
landcover = read_stars(system.file("raster/landcover2015s.tif", package = "motif"))

landcover_cove = lsp_signature(landcover, type = "cove", threshold = 0.9, window = 400)
landcover_cove

dist_cov = lsp_to_dist(landcover_cove, dist_fun = "jensen-shannon")
dist_cov

\donttest{
# larger data example
library(stars)
landcover = read_stars(system.file("raster/landcover2015.tif", package = "motif"))

landcover_cove = lsp_signature(landcover, type = "cove", threshold = 0.9, window = 2000)
landcover_cove

dist_cov = lsp_to_dist(landcover_cove, dist_fun = "jensen-shannon")
dist_cov
}
}
