% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsp_add_spatial.R
\name{lsp_add_stars}
\alias{lsp_add_stars}
\alias{lsp_add_stars.default}
\alias{lsp_add_stars.lsp}
\title{Creates or adds a stars object}
\usage{
lsp_add_stars(x = NULL, window = NULL, metadata = TRUE)

\method{lsp_add_stars}{default}(x = NULL, window = NULL, metadata = TRUE)

\method{lsp_add_stars}{lsp}(x = NULL, window = NULL, metadata = TRUE)
}
\arguments{
\item{x}{Object of class \code{stars} or \code{lsp}.
For \code{stars}, \code{window} or \code{window_size} can be used.}

\item{window}{Specifies areas for analysis. It can be either: \code{NULL}, a numeric value, or an \code{sf} object. If \code{window=NULL} calculations are performed for a whole area. If the \code{window} argument is numeric, it is a length of the side of a square-shaped block of cells. Expressed in the numbers of cells, it defines the extent of a local pattern. If an \code{sf} object is provided, each feature (row) defines the extent of a local pattern. The \code{sf} object should have one attribute (otherwise, the first attribute is used as an id).}

\item{metadata}{Logical. Only when \verb{x`` is of class }lsp\verb{. If }TRUE\verb{, the output object will have metadata ("id" and "na_prop"). If }FALSE`, the output object will not have metadata ("id" and "na_prop").}
}
\value{
A \code{stars} object converted from the input object or a provided set of parameters
}
\description{
Creates or adds a stars object based on the input object or a set of parameters.
It accepts either an object of class \code{stars} or \code{lsp}.
In the first case, the output is created based on
the \code{window} parameter.
In the second case, the output converts the \code{lsp} object into
a \code{stars} object.
}
\examples{
library(stars)
landform = read_stars(system.file("raster/landforms.tif", package = "motif"))
plot(landform)
landform_lsp = lsp_add_stars(landform, window = 100)
plot(landform_lsp)

lc_cove = lsp_signature(landform, type = "cove", window = 200, normalization = "pdf")
lc_cove_lsp = lsp_add_stars(lc_cove)
plot(lc_cove_lsp)
plot(lc_cove_lsp["na_prop"])


\donttest{
# larger data example
library(stars)
landform = read_stars(system.file("raster/landform.tif", package = "motif"))
plot(landform)
landform_lsp = lsp_add_stars(landform, window = 100)
plot(landform_lsp)

lc_cove = lsp_signature(landform, type = "cove", window = 200, normalization = "pdf")
lc_cove_lsp = lsp_add_stars(lc_cove)
plot(lc_cove_lsp)
plot(lc_cove_lsp["na_prop"])
}
}
