% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsem_mplus.R
\name{modsem_mplus}
\alias{modsem_mplus}
\title{Estimation latent interactions through \code{Mplus}}
\usage{
modsem_mplus(
  model.syntax,
  data,
  estimator = "ml",
  cluster = NULL,
  type = ifelse(is.null(cluster), yes = "random", no = "complex"),
  algorithm = "integration",
  processors = 2,
  integration = 15,
  rcs = FALSE,
  rcs.choose = NULL,
  rcs.scale.corrected = TRUE,
  output.std = TRUE,
  ...
)
}
\arguments{
\item{model.syntax}{lavaan/modsem syntax}

\item{data}{dataset}

\item{estimator}{estimator argument passed to \code{Mplus}.}

\item{cluster}{cluster argument passed to \code{Mplus}.}

\item{type}{type argument passed to \code{Mplus}.}

\item{algorithm}{algorithm argument passed to \code{Mplus}.}

\item{processors}{processors argument passed to \code{Mplus}.}

\item{integration}{integration argument passed to \code{Mplus}.}

\item{rcs}{Should latent variable indicators be replaced with reliability-corrected
single item indicators instead? See \code{\link{relcorr_single_item}}.}

\item{rcs.choose}{Which latent variables should get their indicators replaced with
reliability-corrected single items? It is passed to \code{\link{relcorr_single_item}}
as the \code{choose} argument.}

\item{rcs.scale.corrected}{Should reliability-corrected items be scale-corrected? If \code{TRUE}
reliability-corrected single items are corrected for differences in factor loadings between
the items. Default is \code{TRUE}.}

\item{output.std}{Should \code{STANDARDIZED} be added to \code{OUTPUT}?}

\item{...}{arguments passed to other functions}
}
\value{
modsem_mplus object
}
\description{
Estimation latent interactions through \code{Mplus}
}
\examples{
# Theory Of Planned Behavior
m1 <- '
# Outer Model
  X =~ x1 + x2
  Z =~ z1 + z2
  Y =~ y1 + y2

# Inner model
  Y ~ X + Z + X:Z
'

\dontrun{
# Check if Mplus is installed
run <- tryCatch({MplusAutomation::detectMplus(); TRUE},
                error = \(e) FALSE)

if (run) {
  est_mplus <- modsem_mplus(m1, data = oneInt)
  summary(est_mplus)
}
}

}
