% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/generics_lavaan.R,
%   R/generics_modsem_da.R
\name{centered_estimates}
\alias{centered_estimates}
\alias{centered_estimates.lavaan}
\alias{centered_estimates.modsem_da}
\title{Get Centered Interaction Term Estimates}
\usage{
centered_estimates(object, ...)

\method{centered_estimates}{lavaan}(
  object,
  monte.carlo = FALSE,
  mc.reps = 10000,
  tolerance.zero = 1e-10,
  ...
)

\method{centered_estimates}{modsem_da}(
  object,
  monte.carlo = FALSE,
  mc.reps = 10000,
  tolerance.zero = 1e-10,
  ...
)
}
\arguments{
\item{object}{An object of class \code{\link{modsem_da}}}

\item{...}{Additional arguments passed to underlying methods. See specific method
documentation for supported arguments, including:}

\item{monte.carlo}{Logical. If \code{TRUE}, use Monte Carlo simulation to estimate
standard errors; if \code{FALSE}, use the delta method (default).}

\item{mc.reps}{Number of Monte Carlo repetitions. Default is 10000.}

\item{tolerance.zero}{Threshold below which standard errors are set to \code{NA}.}
}
\value{
A \code{data.frame} with centered estimates in the \code{est} column.
}
\description{
Computes centered estimates of model parameters. This is relevant when there is an
 interaction term in the model, as the simple main effects depend upon the mean structure
 of the structural model. Currenlty only available for
 \code{\link{modsem_da}} and \code{lavaan} object.
 It is not relevant for the PI approaches (excluding the "pind" method, which is not recommended),
 since the indicators are centered before computing the product terms.
 The centering can be applied to observed variable interactions in \code{lavaan} models
 and latent interactions estimated using the \code{sam} function.
}
\section{Methods (by class)}{
\itemize{
\item \code{centered_estimates(lavaan)}: Method for \code{lavaan} objects

\item \code{centered_estimates(modsem_da)}: Method for \code{modsem_da} objects

}}
\examples{
m1 <- '
  # Outer Model
  X =~ x1 + x2 + x3
  Z =~ z1 + z2 + z3
  Y =~ y1 + y2 + y3

  # Inner Model
  Y ~ X + Z + X:Z
'
\dontrun{
est_lms <- modsem(m1, oneInt, method = "lms")
centered_estimates(est_lms)
}

}
