% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TRC.R
\name{TRC}
\alias{TRC}
\title{Transformed rank correlations for multivariate outlier detection}
\usage{
TRC(
  data,
  weights,
  overlap = 3,
  mincor = 0,
  robust.regression = "rank",
  gamma = 0.5,
  prob.quantile = 0.75,
  alpha = 0.05,
  md.type = "m",
  monitor = FALSE
)
}
\arguments{
\item{data}{a data frame or matrix with the data.}

\item{weights}{sampling weights.}

\item{overlap}{minimum number of jointly observed values for calculating
the rank correlation.}

\item{mincor}{minimal absolute correlation to impute.}

\item{robust.regression}{type of regression: \code{"irls"} is iteratively
reweighted least squares M-estimator, \code{"rank"} is based on the rank
correlations.}

\item{gamma}{minimal number of jointly observed values to impute.}

\item{prob.quantile}{if mads are 0, try this quantile of absolute deviations.}

\item{alpha}{\code{(1 - alpha)} Quantile of F-distribution is used for cut-off.}

\item{md.type}{type of Mahalanobis distance when missing values occur:
\code{"m"} marginal (default), \code{"c"} conditional.}

\item{monitor}{if \code{TRUE}, verbose output.}
}
\value{
\code{TRC} returns a list whose first component \code{output} is a
sublist with the following components:
\describe{
  \item{\code{sample.size}}{Number of observations}
  \item{\code{number.of.variables}}{Number of variables}
  \item{\code{number.of.missing.items}}{Number of missing values}
  \item{\code{significance.level}}{\code{1 - alpha}}
  \item{\code{computation.time}}{Elapsed computation time}
  \item{\code{medians}}{Componentwise medians}
  \item{\code{mads}}{Componentwise mads}
  \item{\code{center}}{Location estimate}
  \item{\code{scatter}}{Covariance estimate}
  \item{\code{robust.regression}}{Input parameter}
  \item{\code{md.type}}{Input parameter}
  \item{\code{cutpoint}}{The default threshold MD-value for the cut-off of outliers}
}
The further components returned by \code{TRC} are:
\describe{
  \item{\code{outind}}{Indicator of outliers}
  \item{\code{dist}}{Mahalanobis distances (with missing values)}
}
}
\description{
\code{TRC} starts from bivariate Spearman correlations and obtains
a positive definite covariance matrix by back-transforming robust
univariate medians and mads of the eigenspace. \code{TRC} can cope
with missing values by a regression imputation using the a robust
regression on the best predictor and it takes sampling weights
into account.
}
\details{
\code{TRC} is similar to a one-step OGK estimator where the starting
covariances are obtained from rank correlations and an ad hoc missing
value imputation plus weighting is provided.
}
\examples{
data(bushfirem, bushfire.weights)
det.res <- TRC(bushfirem, weights = bushfire.weights)
PlotMD(det.res$dist, ncol(bushfirem))
print(det.res)
}
\references{
Béguin, C. and Hulliger, B. (2004) Multivariate outlier detection in
incomplete survey data: the epidemic algorithm and transformed rank correlations,
JRSS-A, 167, Part 2, pp. 275-294.
}
\author{
Beat Hulliger
}
