% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-modeltime_table.R
\name{update_model_description}
\alias{update_model_description}
\alias{update_modeltime_description}
\title{Update the model description by model id in a Modeltime Table}
\usage{
update_model_description(object, .model_id, .new_model_desc)

update_modeltime_description(object, .model_id, .new_model_desc)
}
\arguments{
\item{object}{A Modeltime Table}

\item{.model_id}{A numeric value matching the .model_id that you want to update}

\item{.new_model_desc}{Text describing the new model description}
}
\description{
The \code{update_model_description()} and \code{update_modeltime_description()} functions
are synonyms.
}
\examples{

m750_models \%>\%
    update_modeltime_description(2, "PROPHET - No Regressors")

}
\seealso{
\itemize{
\item \code{\link[=combine_modeltime_tables]{combine_modeltime_tables()}}: Combine 2 or more Modeltime Tables together
\item \code{\link[=add_modeltime_model]{add_modeltime_model()}}: Adds a new row with a new model to a Modeltime Table
\item \code{\link[=drop_modeltime_model]{drop_modeltime_model()}}: Drop one or more models from a Modeltime Table
\item \code{\link[=update_modeltime_description]{update_modeltime_description()}}: Updates a description for a model inside a Modeltime Table
\item \code{\link[=update_modeltime_model]{update_modeltime_model()}}: Updates a model inside a Modeltime Table
\item \code{\link[=pull_modeltime_model]{pull_modeltime_model()}}: Extracts a model from a Modeltime Table
}
}
